within Modelica_Synchronous;
package Types "Library of types with choices, especially to build menus"
extends Modelica.Icons.TypesPackage;

  type SolverMethod = ModelicaServices.Types.SolverMethod;
  type Resolution = enumeration(
      y "y (year)",
      d "d (day)",
      h "h (hour)",
      m "min (minutes)",
      s "s (seconds)",
      ms "ms (milli seconds)",
      us "us (micro seconds)",
      ns "ns (nano seconds)")
    "Enumeration defining the resolution of a clocked signal"
                                                            annotation (
    Documentation(info="<html>
<p>
Enumeration defining the resolution of a clock signal, especially
of the clock signal generated by block
<a href=\"modelica://Modelica_Synchronous.ClockSignals.Clocks.PeriodicExactClock\">PeriodicExactClock</a>.
The following values are possible:<br>&nbsp;
</p>

<table border=1 cellspacing=0 cellpadding=2>
<tr><th><b>Types.Resolution.</b></th><th><b>Meaning</b></th></tr>
<tr><td valign=\"top\">y</td>
    <td valign=\"top\">year (= 365*24*60*60 seconds)</td></tr>

<tr><td valign=\"top\">d</td>
    <td valign=\"top\">day (= 24*60*60 seconds)</td></tr>

<tr><td valign=\"top\">h</td>
    <td valign=\"top\">hour (= 60*60 seconds)</td></tr>

<tr><td valign=\"top\">m</td>
    <td valign=\"top\">minute (= 60 seconds)</td></tr>

<tr><td valign=\"top\">s</td>
    <td valign=\"top\">seconds</td></tr>

<tr><td valign=\"top\">ms</td>
    <td valign=\"top\">milli seconds (= 1/1000 seconds)</td></tr>


<tr><td valign=\"top\">us</td>
    <td valign=\"top\">micro seconds (= 1/(1000*1000) seconds)</td></tr>


<tr><td valign=\"top\">ns</td>
    <td valign=\"top\">nano seconds (= 1/(1000*1000*1000) seconds)</td></tr>
</table>
<p>
</p>
</html>"));

annotation (Documentation(info="<html>
<p>
This package contains type definitions utilized
in blocks of the Modelica_Synchronous package.
</p>
</html>"));
end Types;
